<?php
// dashboard.php

session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php"); // Redirect to login page if not logged in
    exit();
}

// Retrieve the username from the session
$username = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Library Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            display: flex;
            height: 100vh;
            overflow: hidden;
            background: linear-gradient(135deg, #00bcd4, #0288d1); /* Gradient blue background */
        }
        .sidebar {
            width: 260px;
            background-color: #0288d1; /* Blue */
            color: #ffffff;
            height: 100%;
            position: fixed;
            top: 0;
            left: 0;
            box-shadow: 0 2px 12px rgba(0,0,0,0.4);
            padding-top: 20px;
            box-sizing: border-box;
            transition: width 0.3s ease;
        }
        .sidebar:hover {
            width: 280px;
        }
        .sidebar .user-info {
            display: flex;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid #01579b; /* Darker blue */
            margin-bottom: 20px;
        }
        .sidebar .user-info i {
            font-size: 36px;
            margin-right: 15px;
        }
        .sidebar .user-info span {
            font-size: 22px;
            font-weight: 600;
        }
        .sidebar a {
            display: block;
            color: #ffffff;
            text-decoration: none;
            padding: 15px 20px;
            font-size: 18px;
            border-bottom: 1px solid #01579b; /* Darker blue */
            transition: background-color 0.3s ease, padding-left 0.3s ease;
        }
        .sidebar a:hover {
            background-color: #01579b; /* Darker blue */
            padding-left: 30px;
        }
        .sidebar a i {
            margin-right: 10px;
        }
        .main-content {
            margin-left: 260px;
            padding: 20px;
            flex-grow: 1;
            overflow-y: auto;
            background: rgba(255, 255, 255, 0.9);
            color: #333;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            min-height: 100vh;
            position: relative;
        }
        .clock {
            position: absolute;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            color: #333;
            padding: 10px 25px;
            font-size: 30px;
            font-weight: 400;
            text-align: center;
            background: rgba(255, 255, 255, 0.8); /* Semi-transparent white background */
            border-radius: 10px;
        }
        .welcome-banner {
            position: absolute;
            top: 80px; /* Below clock */
            left: 50%;
            transform: translateX(-50%);
            background: #0288d1; /* Blue */
            color: #ffffff;
            padding: 15px 30px;
            border-radius: 8px;
            font-size: 20px;
            font-weight: 500;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        }
        .info-cards {
            display: flex;
            justify-content: space-between;
            margin-top: 180px; /* Space for clock and welcome banner */
        }
        .info-card {
            background: rgba(255, 255, 255, 0.9);
            color: #0288d1;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            width: 30%;
            text-align: center;
        }
        .info-card h3 {
            margin: 0 0 10px;
            font-size: 24px;
        }
        .info-card p {
            font-size: 18px;
            margin: 0;
        }
        /* Responsive Design */
        @media (max-width: 768px) {
            .sidebar {
                width: 200px;
            }
            .sidebar:hover {
                width: 200px;
            }
            .main-content {
                margin-left: 200px;
            }
            .info-cards {
                flex-direction: column;
                align-items: center;
            }
            .info-card {
                width: 80%;
                margin-bottom: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="user-info">
            <i class="fas fa-user-circle"></i>
            <span><?php echo htmlspecialchars($username); ?></span>
        </div>
        <a href="give_book.php"><i class="fas fa-book"></i> Give Book</a>
        <a href="returnbook.php"><i class="fas fa-undo"></i> Return Book</a>
        <a href="manage_book.php"><i class="fas fa-cogs"></i> Manage Book</a>
        <a href="Insert_book.php"><i class="fas fa-plus-circle"></i> Insert Book</a>
   
  

        <a href="generate_reports.php"><i class="fas fa-file-alt"></i> Generate Reports</a>
     
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>
    <div class="main-content">
        <div class="clock" id="clock"></div>
        
       
    </div>
    <script>
        function updateClock() {
            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');
            document.getElementById('clock').innerText = `${hours}:${minutes}:${seconds}`;
        }
        setInterval(updateClock, 1000);
        updateClock(); // Initial call to display clock immediately
    </script>
</body>
</html>
